function [ DropIn, DropOut, V1, V2 ] = Sub_Equilibrate_All_V03( V1, Rin, PVHS_bot_in, PVHS_top_in, V2, Rout, PVHS_bot_out, PVHS_top_out, Rflu, h, simEnd, dt, n, log )

%% SIMULATION SETUP
% ---------------
% Setup arrays to plot the evolution of the radii
% ---------------

% Global physical variables
%global rho g gamma ;

% Create the output structures
DropIn  = struct('volume', zeros(1,n), 'pressure', zeros(1,n), 'topradius', zeros(1,n), 'botradius', zeros(1,n), 'topheight', zeros(1,n), 'botheight', zeros(1,n), 'endIndex', 1);
DropOut = struct('volume', zeros(1,n), 'pressure', zeros(1,n), 'topradius', zeros(1,n), 'botradius', zeros(1,n), 'topheight', zeros(1,n), 'botheight', zeros(1,n), 'endIndex', 1);

%% SIMULATION RUN
% While the system is not equilibrated, exchange volume between the 
% two drops

% While the conditions of end of simulations have not been met
% Keep looping the fluid exchange
index  = 1    ;
runSim = true ;
while runSim
    
    % ---------------
    % Equilibrate input
    % ---------------
    [ HRV1top, HRV1bot ] = Sub_Equilibrate_Side_V03( V1, Rin, PVHS_bot_in, PVHS_top_in, h, log ) ;
    H11              = HRV1top.height   ;
    R11              = HRV1top.radius   ;
    V11              = HRV1top.volume   ;
    H12              = HRV1bot.height   ;
    R12              = HRV1bot.radius   ;
    V12              = HRV1bot.volume   ;
    P1               = HRV1top.pressure ;
    
    % ---------------
    % Equilibrate output
    % ---------------
    [ HRV2top, HRV2bot ] = Sub_Equilibrate_Side_V03( V2, Rout, PVHS_bot_out, PVHS_top_out, h, log ) ;
    H21              = HRV2top.height   ;
    R21              = HRV2top.radius   ;
    V21              = HRV2top.volume   ;
    H22              = HRV2bot.height   ;
    R22              = HRV2bot.radius   ;
    V22              = HRV2bot.volume   ;
    P2               = HRV2top.pressure ;
    
    % ---------------
    % Store variables
    % ---------------
    DropIn.topradius(index)    = R11  ;
    DropIn.botradius(index)    = R12  ;
    DropOut.topradius(index)   = R21  ;
    DropOut.botradius(index)   = R22  ;
    
    DropIn.topheight(index)    = H11  ;
    DropIn.botheight(index)    = H12  ;
    DropOut.topheight(index)   = H21  ;
    DropOut.botheight(index)   = H22  ;
    
    V1                         = V11 + V12   ;
    V2                         = V21 + V22   ;
    DropIn.volume(index)       = V1   ;
    DropOut.volume(index)      = V2   ;
    DropIn.pressure(index)     = P1   ;
    DropOut.pressure(index)    = P2   ;
    
    % Create the output structures

    % Calculate the pressure difference between port 1 and 2
    Pdiff = abs(P1-P2) ;

    % Calculate the pressure difference and if it's lower than the 
    % equilibration conditions then flag the simulation to stop
    if Pdiff < simEnd
        display('Equilibrate LEFT-RIGHT Simulation ended successfully (equilibrium reached)');
        
        DropIn.topradius(index:n)  = R11   ;
        DropIn.botradius(index:n)  = R12   ;
        DropOut.topradius(index:n) = R21   ;
        DropOut.botradius(index:n) = R22   ;

        DropIn.topheight(index:n)  = H11   ;
        DropIn.botheight(index:n)  = H12   ;
        DropOut.topheight(index:n) = H21   ;
        DropOut.botheight(index:n) = H22   ;

        DropIn.volume(index:n)     = V1    ;
        DropOut.volume(index:n)    = V2    ;
        DropIn.pressure(index:n)   = P1    ;
        DropOut.pressure(index:n)  = P2    ;
        
        DropIn.endIndex            = index ;
        DropOut.endIndex           = index ;
        
        break ;
    end
    
    % Exchange some fluid between the two ports
    %dV = dt * Pdiff * (V2+V1)         ;
    dV = dt * Pdiff / Rflu             ;
    
    if (P1 > P2)
        V1 = V1 - dV  ;
        V2 = V2 + dV  ;
    else
        V1 = V1 + dV  ;
        V2 = V2 - dV  ;
    end
    
    % increment while loop index
    index = index + 1;
    if (log == true) 
        display(['Vex = ' num2str(dV) '  N =  ' num2str(index) '   Pdiff =' num2str(Pdiff)]);
    end
    
    % if the index is too high, escape the loop
    if index > 10000
        display('Equilibrate LEFT-RIGHT Simulation ended without converging');
        index = index - 1;
        
        DropIn.endIndex  = index ;
        DropOut.endIndex = index ;
        
        break;
    end
end

